/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client;

import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.confluence.mod.client.gui.hud.TerraStyleArmorHud;
import org.confluence.mod.client.gui.hud.TerraStyleFoodHud;
import org.confluence.mod.client.gui.hud.TerraStyleHealthHud;
import org.confluence.mod.client.gui.hud.TerraStyleManaHud;
import org.confluence.mod.client.gui.hud.TerraStyleSoulHud;
import org.confluence.mod.client.handler.StarPhaseHandler;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.terraentity.client.gui.container.TETradeScreen;
import org.jetbrains.annotations.NotNull;

public final class ClientConfigs {
    public static int showWindParticles = 90;
    public static boolean achievementToast = true;
    public static SellPriceDisplay sellPriceDisplay = SellPriceDisplay.EVERYWHERE;
    public static float minEctoMistEffectRadius = 10.0f;
    public static boolean terraStyleHealth = true;
    public static TerraStyleHealthHud.Health healthStyle = TerraStyleHealthHud.Health.OVERLAY;
    public static int healthOffsetX = 0;
    public static int healthOffsetY = 0;
    public static boolean terraStyleFood = true;
    public static TerraStyleFoodHud.Food foodStyle = TerraStyleFoodHud.Food.OVERLAY;
    public static TerraStyleManaHud.Mana manaStyle = TerraStyleManaHud.Mana.OVERLAY;
    public static int manaOffsetX = 0;
    public static int manaOffsetY = 0;
    public static TerraStyleSoulHud.Soul soulStyle = TerraStyleSoulHud.Soul.OVERLAY;
    public static int soulOffsetX = 0;
    public static int soulOffsetY = 0;
    public static boolean terraStyleArmor = true;
    public static TerraStyleArmorHud.Armor armorStyle = TerraStyleArmorHud.Armor.OVERLAY;
    public static boolean leftEffectIcon = true;
    public static int extraInventoryButtonOffsetX = 0;
    public static int extraInventoryButtonOffsetY = 0;
    public static boolean bloodyEffect = true;
    public static GoreEffect goreEffect = GoreEffect.CONFLUENCE_VANILLA;
    public static boolean damageIndicator = true;
    public static boolean healIndicator = true;
    private static ModConfigSpec.IntValue SHOW_WIND_PARTICLES;
    private static ModConfigSpec.BooleanValue ACHIEVEMENT_TOAST;
    private static ModConfigSpec.EnumValue<SellPriceDisplay> SELL_PRICE_DISPLAY;
    private static ModConfigSpec.IntValue MIN_ECTO_MIST_EFFECT_RADIUS;
    private static ModConfigSpec.BooleanValue TERRA_STYLE_HEALTH;
    private static ModConfigSpec.EnumValue<TerraStyleHealthHud.Health> HEALTH_STYLE;
    private static ModConfigSpec.IntValue HEALTH_OFFSET_X;
    private static ModConfigSpec.IntValue HEALTH_OFFSET_Y;
    private static ModConfigSpec.BooleanValue TERRA_STYLE_FOOD;
    private static ModConfigSpec.EnumValue<TerraStyleFoodHud.Food> FOOD_STYLE;
    private static ModConfigSpec.EnumValue<TerraStyleManaHud.Mana> MANA_STYLE;
    private static ModConfigSpec.IntValue MANA_OFFSET_X;
    private static ModConfigSpec.IntValue MANA_OFFSET_Y;
    private static ModConfigSpec.EnumValue<TerraStyleSoulHud.Soul> SOUL_STYLE;
    private static ModConfigSpec.IntValue SOUL_OFFSET_X;
    private static ModConfigSpec.IntValue SOUL_OFFSET_Y;
    private static ModConfigSpec.BooleanValue TERRA_STYLE_ARMOR;
    private static ModConfigSpec.EnumValue<TerraStyleArmorHud.Armor> ARMOR_STYLE;
    private static ModConfigSpec.BooleanValue LEFT_EFFECT_ICON;
    private static ModConfigSpec.IntValue EXTRA_INVENTORY_BUTTON_OFFSET_X;
    private static ModConfigSpec.IntValue EXTRA_INVENTORY_BUTTON_OFFSET_Y;
    private static ModConfigSpec.BooleanValue BLOODY_EFFECT;
    private static ModConfigSpec.EnumValue<GoreEffect> GORE_EFFECT;
    private static ModConfigSpec.BooleanValue DAMAGE_INDICATOR;
    private static ModConfigSpec.BooleanValue HEAL_INDICATOR;

    public static void onLoad() {
        showWindParticles = (Integer)SHOW_WIND_PARTICLES.get();
        achievementToast = (Boolean)ACHIEVEMENT_TOAST.get();
        sellPriceDisplay = (SellPriceDisplay)((Object)SELL_PRICE_DISPLAY.get());
        minEctoMistEffectRadius = ((Integer)MIN_ECTO_MIST_EFFECT_RADIUS.get()).intValue();
        terraStyleHealth = (Boolean)TERRA_STYLE_HEALTH.get();
        healthStyle = (TerraStyleHealthHud.Health)((Object)HEALTH_STYLE.get());
        healthOffsetX = (Integer)HEALTH_OFFSET_X.get();
        healthOffsetY = (Integer)HEALTH_OFFSET_Y.get();
        foodStyle = (TerraStyleFoodHud.Food)((Object)FOOD_STYLE.get());
        manaStyle = (TerraStyleManaHud.Mana)((Object)MANA_STYLE.get());
        manaOffsetX = (Integer)MANA_OFFSET_X.get();
        manaOffsetY = (Integer)MANA_OFFSET_Y.get();
        soulStyle = (TerraStyleSoulHud.Soul)((Object)SOUL_STYLE.get());
        soulOffsetX = (Integer)SOUL_OFFSET_X.get();
        soulOffsetY = (Integer)SOUL_OFFSET_Y.get();
        terraStyleArmor = (Boolean)TERRA_STYLE_ARMOR.get();
        armorStyle = (TerraStyleArmorHud.Armor)((Object)ARMOR_STYLE.get());
        terraStyleFood = (Boolean)TERRA_STYLE_FOOD.get();
        leftEffectIcon = (Boolean)LEFT_EFFECT_ICON.get();
        extraInventoryButtonOffsetX = (Integer)EXTRA_INVENTORY_BUTTON_OFFSET_X.get();
        extraInventoryButtonOffsetY = (Integer)EXTRA_INVENTORY_BUTTON_OFFSET_Y.get();
        bloodyEffect = (Boolean)BLOODY_EFFECT.get();
        goreEffect = GORE_EFFECT != null ? (GoreEffect)((Object)GORE_EFFECT.get()) : GoreEffect.OFF;
        damageIndicator = (Boolean)DAMAGE_INDICATOR.get();
        healIndicator = (Boolean)HEAL_INDICATOR.get();
        StarPhaseHandler.enabled = (Boolean)CommonConfigs.STAR_PHASE.get();
    }

    public static void register(ModContainer container) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        SHOW_WIND_PARTICLES = builder.defineInRange("showWindParticles", 90, 0, 100);
        ACHIEVEMENT_TOAST = builder.define("achievementToast", true);
        SELL_PRICE_DISPLAY = builder.defineEnum("sellPriceDisplay", (Enum)SellPriceDisplay.EVERYWHERE);
        MIN_ECTO_MIST_EFFECT_RADIUS = builder.defineInRange("minEctoMistEffectRadius", 10, 0, 100);
        builder.push("HUD");
        builder.push("Health");
        TERRA_STYLE_HEALTH = builder.define("terraStyleHealth", true);
        HEALTH_STYLE = builder.defineEnum("healthStyle", (Enum)TerraStyleHealthHud.Health.OVERLAY);
        HEALTH_OFFSET_X = builder.defineInRange("healthOffsetX", 0, -256, 256);
        HEALTH_OFFSET_Y = builder.defineInRange("healthOffsetY", 0, -256, 256);
        builder.pop();
        builder.push("Food");
        TERRA_STYLE_FOOD = builder.define("terraStyleFood", true);
        FOOD_STYLE = builder.defineEnum("foodStyle", (Enum)TerraStyleFoodHud.Food.OVERLAY);
        builder.pop();
        builder.push("Mana");
        MANA_STYLE = builder.defineEnum("manaStyle", (Enum)TerraStyleManaHud.Mana.OVERLAY);
        MANA_OFFSET_X = builder.defineInRange("manaOffsetX", 0, -256, 256);
        MANA_OFFSET_Y = builder.defineInRange("manaOffsetY", 0, -256, 256);
        builder.pop();
        builder.push("Soul");
        SOUL_STYLE = builder.defineEnum("soulStyle", (Enum)TerraStyleSoulHud.Soul.OVERLAY);
        SOUL_OFFSET_X = builder.defineInRange("soulOffsetX", 0, -256, 256);
        SOUL_OFFSET_Y = builder.defineInRange("soulOffsetY", 0, -256, 256);
        builder.pop();
        builder.push("Armor");
        TERRA_STYLE_ARMOR = builder.define("terraStyleArmor", true);
        ARMOR_STYLE = builder.defineEnum("armorStyle", (Enum)TerraStyleArmorHud.Armor.OVERLAY);
        builder.pop();
        LEFT_EFFECT_ICON = builder.define("leftEffectIcon", true);
        EXTRA_INVENTORY_BUTTON_OFFSET_X = builder.defineInRange("extraInventoryButtonOffsetX", 0, -256, 256);
        EXTRA_INVENTORY_BUTTON_OFFSET_Y = builder.defineInRange("extraInventoryButtonOffsetY", 0, -256, 256);
        builder.pop();
        builder.push("Entity");
        BLOODY_EFFECT = builder.define("bloodyEffect", true);
        if (!ModList.get().isLoaded("yes_steve_model")) {
            GORE_EFFECT = builder.defineEnum("goreEffect", (Enum)GoreEffect.CONFLUENCE_VANILLA);
        }
        DAMAGE_INDICATOR = builder.define("damageIndicator", true);
        HEAL_INDICATOR = builder.define("healIndicator", true);
        builder.pop();
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)builder.build());
    }

    public static enum SellPriceDisplay implements TranslatableEnum
    {
        NEVER{

            @Override
            public boolean test() {
                return false;
            }
        }
        ,
        EVERYWHERE{

            @Override
            public boolean test() {
                return true;
            }
        }
        ,
        TRADE_SCREEN{

            @Override
            public boolean test() {
                return Minecraft.getInstance().screen instanceof TETradeScreen;
            }
        };


        public abstract boolean test();

        @NotNull
        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.sellPriceDisplay." + this.name().toLowerCase(Locale.ROOT)));
        }
    }

    public static enum GoreEffect implements TranslatableEnum
    {
        OFF,
        CONFLUENCE,
        CONFLUENCE_VANILLA,
        ALL;


        @NotNull
        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.goreEffect." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

