/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.api.lunar.eightchar;

import org.confluence.mod.api.lunar.Lunar;
import org.confluence.mod.api.lunar.eightchar.DaYun;
import org.confluence.mod.api.lunar.eightchar.LiuYue;
import org.confluence.mod.api.lunar.util.LunarUtil;

public class LiuNian {
    private final int index;
    private final DaYun daYun;
    private final int year;
    private final int age;
    private final Lunar lunar;

    public LiuNian(DaYun daYun, int index) {
        this.daYun = daYun;
        this.lunar = daYun.getLunar();
        this.index = index;
        this.year = daYun.getStartYear() + index;
        this.age = daYun.getStartAge() + index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getYear() {
        return this.year;
    }

    public int getAge() {
        return this.age;
    }

    public String getGanZhi() {
        int offset = LunarUtil.getJiaZiIndex(this.lunar.getJieQiTable().get("\u7acb\u6625").getLunar().getYearInGanZhiExact()) + this.index;
        if (this.daYun.getIndex() > 0) {
            offset += this.daYun.getStartAge() - 1;
        }
        return LunarUtil.JIA_ZI[offset %= LunarUtil.JIA_ZI.length];
    }

    public String getXun() {
        return LunarUtil.getXun(this.getGanZhi());
    }

    public String getXunKong() {
        return LunarUtil.getXunKong(this.getGanZhi());
    }

    public LiuYue[] getLiuYue() {
        int n = 12;
        LiuYue[] l = new LiuYue[n];
        for (int i = 0; i < n; ++i) {
            l[i] = new LiuYue(this, i);
        }
        return l;
    }
}

