/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.api.event;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MinecartAbilityEvent
extends PlayerEvent {
    @Nullable
    protected AbstractMinecart minecart;

    public MinecartAbilityEvent(Player player, @Nullable AbstractMinecart minecart) {
        super(player);
        this.minecart = minecart;
    }

    @Nullable
    public AbstractMinecart getMinecart() {
        return this.minecart;
    }

    public static class DismountOnMinecart
    extends MinecartAbilityEvent
    implements ICancellableEvent {
        @Nullable
        private ItemStack minecartItem;

        public DismountOnMinecart(Player player, AbstractMinecart minecart) {
            super(player, minecart);
        }

        public void setMinecartItem(@NotNull ItemStack minecartItem) {
            this.minecartItem = minecartItem;
        }

        @Nullable
        public ItemStack getMinecartItem() {
            return this.minecartItem;
        }

        @Override
        @NotNull
        public AbstractMinecart getMinecart() {
            return Objects.requireNonNull(this.minecart);
        }
    }

    public static class RightClickRailBlock
    extends MinecartAbilityEvent
    implements ICancellableEvent {
        private final ItemStack minecartItem;
        private final BlockState blockState;
        private final BaseRailBlock railBlock;
        private final BlockPos blockPos;

        public RightClickRailBlock(Player player, ItemStack minecartItem, BlockState blockState, BaseRailBlock railBlock, BlockPos blockPos) {
            super(player, null);
            this.minecartItem = minecartItem;
            this.blockState = blockState;
            this.railBlock = railBlock;
            this.blockPos = blockPos;
        }

        public ItemStack getMinecartItem() {
            return this.minecartItem;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public BaseRailBlock getRailBlock() {
            return this.railBlock;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public void setMinecart(@NotNull AbstractMinecart minecart) {
            this.minecart = minecart;
        }
    }
}

