/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.worldgen.secret_seed.SecretSeed;
import org.confluence.mod.mixed.IMinecraftServer;

public interface SecretFlagMatcher {
    public long secretFlag();

    public boolean flipMatch();

    default public boolean matchesSecretFlag() {
        return IMinecraftServer.matchesSecretFlag(this.secretFlag()) != this.flipMatch();
    }

    public static <M extends SecretFlagMatcher> MapCodec<M> createMapCodec(BiFunction<Long, Boolean, M> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.LONG, (Codec)Codec.STRING).fieldOf("flag").forGetter(matcher -> Either.left((Object)matcher.secretFlag())), (App)Codec.BOOL.lenientOptionalFieldOf("flip", (Object)false).forGetter(SecretFlagMatcher::flipMatch)).apply((Applicative)instance, (n, b) -> (SecretFlagMatcher)factory.apply((Long)n.map(Function.identity(), str -> {
            long ret = 0L;
            if (str.startsWith("&")) {
                try {
                    ret = Long.parseLong(str.substring(1), 2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                ret = ((Number)ModSecretSeeds.CODEC.parse((DynamicOps)JavaOps.INSTANCE, str).mapOrElse(SecretSeed::getFlag, err -> {
                    try {
                        return Long.parseLong(str);
                    }
                    catch (NumberFormatException ignored) {
                        return 0;
                    }
                })).longValue();
            }
            if (ret == 0L) {
                Confluence.LOGGER.error("Can not decode '{}'!", str);
            }
            return ret;
        }), (Boolean)b)));
    }
}

