/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.nbt.StringTag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EnumValue<T>
extends BaseValue<T> {
    private final NameMap<T> nameMap;

    EnumValue(SNBTConfig c, String key, NameMap<T> nameMap) {
        this(c, key, nameMap, nameMap.defaultValue);
    }

    EnumValue(SNBTConfig c, String key, NameMap<T> nameMap, T def) {
        super(c, key, def);
        this.nameMap = nameMap;
    }

    @Override
    public void set(T v) {
        if (this.nameMap.values.contains(v)) {
            super.set(v);
        } else {
            super.set(this.defaultValue);
        }
    }

    @Override
    public void write(SNBTCompoundTag tag) {
        ArrayList<CallSite> s = new ArrayList<CallSite>(this.comment);
        s.add((CallSite)((Object)("Default: \"" + this.nameMap.getName(this.defaultValue) + "\"")));
        s.add((CallSite)((Object)("Valid values: " + this.nameMap.keys.stream().map(StringTag::quoteAndEscape).collect(Collectors.joining(", ")))));
        tag.comment(this.key, String.join((CharSequence)"\n", s));
        tag.putString(this.key, this.nameMap.getName(this.get()));
    }

    @Override
    public void read(SNBTCompoundTag tag) {
        this.set(this.nameMap.get(tag.getString(this.key)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void createClientConfig(ConfigGroup group) {
        group.addEnum(this.key, this.get(), this::set, this.nameMap).setCanEdit(this.enabled.getAsBoolean());
    }
}

