/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.ctm;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.ctm.CTMModelBakeryAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.chisel.ctm.CTM;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.model.ModelCTM;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;
import team.chisel.ctm.client.util.TextureMetadataHandler;

@Mixin(value={TextureMetadataHandler.class})
@RequiresMod(value="ctm")
@ClientOnlyMixin
public abstract class TextureMetadataHandlerMixin
implements ModernFixClientIntegration {
    @Shadow(remap=false)
    @Final
    private Multimap<ResourceLocation, Material> scrapedTextures;

    @Shadow(remap=false)
    @Nonnull
    protected abstract BakedModel wrap(UnbakedModel var1, BakedModel var2) throws IOException;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void subscribeDynamic(CallbackInfo ci) {
        ModernFixClient.CLIENT_INTEGRATIONS.add(this);
    }

    @Inject(method={"onModelBake(Lnet/neoforged/neoforge/client/event/ModelEvent$BakingCompleted;)V", "onModelBake(Lnet/neoforged/neoforge/client/event/ModelEvent$ModifyBakingResult;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void noIteration(CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public BakedModel onBakedModelLoad(ModelResourceLocation mrl, UnbakedModel rootModel, BakedModel baked, ModelState state, ModelBakery bakery, ModelBakery.TextureGetter getter) {
        if (!(baked instanceof AbstractCTMBakedModel) && !baked.isCustomRenderer()) {
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            dependencies.push(mrl.id());
            seenModels.add(mrl.id());
            boolean shouldWrap = false;
            HashSet errors = new HashSet();
            while (!shouldWrap && !dependencies.isEmpty()) {
                UnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == mrl.id() ? rootModel : bakery.getModel(dep);
                }
                catch (Exception e) {
                    continue;
                }
                HashSet textures = Sets.newHashSet((Iterable)this.scrapedTextures.get((Object)dep));
                Collection newDependencies = model.getDependencies();
                for (Material tex : textures) {
                    IMetadataSectionCTM meta = null;
                    try {
                        meta = ResourceUtil.getMetadata((ResourceLocation)ResourceUtil.spriteToAbsolute((ResourceLocation)tex.texture())).orElse(null);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (meta == null) continue;
                    shouldWrap = true;
                }
                for (ResourceLocation newDep : newDependencies) {
                    if (!seenModels.add(newDep)) continue;
                    dependencies.push(newDep);
                }
            }
            if (shouldWrap) {
                try {
                    baked = this.wrap(rootModel, baked);
                    this.handleInit(mrl, baked, bakery, getter);
                    dependencies.clear();
                }
                catch (IOException e) {
                    CTM.logger.error("Could not wrap model " + String.valueOf(mrl) + ". Aborting...", (Throwable)e);
                }
            }
        }
        return baked;
    }

    private void handleInit(ModelResourceLocation key, BakedModel wrappedModel, ModelBakery bakery, ModelBakery.TextureGetter spriteGetter) {
        ModelCTM ctmModel;
        AbstractCTMBakedModel baked;
        IModelCTM var10;
        if (wrappedModel instanceof AbstractCTMBakedModel && (var10 = (baked = (AbstractCTMBakedModel)wrappedModel).getModel()) instanceof ModelCTM && !(ctmModel = (ModelCTM)var10).isInitialized()) {
            ((CTMModelBakeryAccessor)bakery).mfix$getBakedCache().clear();
            ModelBakery modelBakery = bakery;
            Objects.requireNonNull(modelBakery);
            ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(modelBakery, spriteGetter, key);
            ctmModel.bake((ModelBaker)baker, m -> spriteGetter.get(key, m), (ModelState)BlockModelRotation.X0_Y0);
        }
    }
}

