/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.executor.test;

import ca.spottedleaf.starlight.interndep.flowsched.executor.ExecutorManager;
import ca.spottedleaf.starlight.interndep.flowsched.executor.LockToken;
import ca.spottedleaf.starlight.interndep.flowsched.executor.Task;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class TestThroughput {
    private static final Semaphore semaphore = new Semaphore(128);
    public static volatile double accumulation = 0.0;
    public static volatile long[] latency = new long[0x100000];
    public static AtomicInteger counter = new AtomicInteger();

    public static void main(String[] args) {
        ExecutorManager manager = new ExecutorManager(4);
        long last = System.nanoTime();
        int schedules = 0;
        ExecutorService pool = Executors.newFixedThreadPool(4);
        while (true) {
            if (schedules >= 0x100000) {
                long now = System.nanoTime();
                System.out.println(String.format("Throughput: %.2f rps, latency: %.2fns, acc: %e", (double)schedules * 1.0E9 / (double)(now - last), Arrays.stream(latency).average().getAsDouble(), accumulation));
                last = now;
                schedules = 0;
            }
            semaphore.acquireUninterruptibly();
            ++schedules;
            pool.execute(new DummyTask());
        }
    }

    static class DummyTask
    implements Task,
    Runnable {
        public static final Runnable EMPTY_RUNNABLE = () -> {};
        private final long start = System.nanoTime();

        DummyTask() {
        }

        @Override
        public void run() {
            this.run(EMPTY_RUNNABLE);
        }

        @Override
        public void run(Runnable releaseLocks) {
            long end = System.nanoTime();
            TestThroughput.latency[TestThroughput.counter.getAndIncrement() & TestThroughput.latency.length - 1] = end - this.start;
            semaphore.release();
            releaseLocks.run();
        }

        @Override
        public void propagateException(Throwable t) {
        }

        @Override
        public LockToken[] lockTokens() {
            return new LockToken[0];
        }

        @Override
        public int priority() {
            return (int)(Math.random() * 128.0);
        }
    }
}

