/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.music.common.init;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.music.ConfluenceMusic;
import org.confluence.music.common.init.CMSoundEvents;
import org.jetbrains.annotations.NotNull;

public final class CMMusics {
    public static final DeferredRegister<CachedLocationMusic> MUSICS = DeferredRegister.create(ConfluenceMusic.CACHED_LOCATION_MUSIC_KEY, (String)"confluence_music");
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLD = CMMusics.register(CMSoundEvents.NEW_JOURNEY, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OVERWORLD_DAY = CMMusics.register(CMSoundEvents.OVERWORLD_DAY, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> ALT_OVERWORLD_DAY = CMMusics.register(CMSoundEvents.ALT_OVERWORLD_DAY, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OVERWORLD_NIGHT = CMMusics.register(CMSoundEvents.OVERWORLD_NIGHT, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> ALT_OVERWORLD_NIGHT = CMMusics.register(CMSoundEvents.ALT_OVERWORLD_NIGHT, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> JOURNEYS_BEGINNING = CMMusics.register(CMSoundEvents.JOURNEYS_BEGINNING, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> JOURNEYS_END = CMMusics.register(CMSoundEvents.JOURNEYS_END, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> TITLE = CMMusics.register(CMSoundEvents.TITLE, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> ALT_TITLE = CMMusics.register(CMSoundEvents.ALT_TITLE, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> DAY_REMIX = CMMusics.register(CMSoundEvents.DAY_REMIX, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> CREATIVE_MODE = CMMusics.register(CMSoundEvents.CREATIVE_MODE, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> SNOW = CMMusics.register(CMSoundEvents.SNOW, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> ICE = CMMusics.register(CMSoundEvents.ICE, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> UNDERGROUND_ICE = CMMusics.register(CMSoundEvents.UNDERGROUND_ICE, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> DESERT = CMMusics.register(CMSoundEvents.DESERT, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> UNDERGROUND_DESERT = CMMusics.register(CMSoundEvents.UNDERGROUND_DESERT, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OCEAN_DAY = CMMusics.register(CMSoundEvents.OCEAN_DAY, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OCEAN_NIGHT = CMMusics.register(CMSoundEvents.OCEAN_NIGHT, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> SPACE_DAY = CMMusics.register(CMSoundEvents.SPACE_DAY, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> SPACE_NIGHT = CMMusics.register(CMSoundEvents.SPACE_NIGHT, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> UNDERGROUND = CMMusics.register(CMSoundEvents.UNDERGROUND, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> ALT_UNDERGROUND = CMMusics.register(CMSoundEvents.ALT_UNDERGROUND, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> MUSHROOMS = CMMusics.register(CMSoundEvents.MUSHROOMS, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> JUNGLE_DAY = CMMusics.register(CMSoundEvents.JUNGLE_DAY, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> JUNGLE_NIGHT = CMMusics.register(CMSoundEvents.JUNGLE_NIGHT, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> UNDERGROUND_JUNGLE = CMMusics.register(CMSoundEvents.UNDERGROUND_JUNGLE, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> THE_CORRUPTION = CMMusics.register(CMSoundEvents.THE_CORRUPTION, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> UNDERGROUND_CORRUPTION = CMMusics.register(CMSoundEvents.UNDERGROUND_CORRUPTION, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> THE_CRIMSON = CMMusics.register(CMSoundEvents.THE_CRIMSON, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> UNDERGROUND_CRIMSON = CMMusics.register(CMSoundEvents.UNDERGROUND_CRIMSON, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> THE_HALLOW_DAY = CMMusics.register(CMSoundEvents.THE_HALLOW_DAY, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> UNDERGROUND_HALLOW = CMMusics.register(CMSoundEvents.UNDERGROUND_HALLOW, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> UNDERWORLD = CMMusics.register(CMSoundEvents.UNDERWORLD, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> TEMPLE = CMMusics.register(CMSoundEvents.TEMPLE, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> AETHER = CMMusics.register(CMSoundEvents.AETHER, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> GRAVEYARD = CMMusics.register(CMSoundEvents.GRAVEYARD, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> TOWN_DAY = CMMusics.register(CMSoundEvents.TOWN_DAY, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> TOWN_NIGHT = CMMusics.register(CMSoundEvents.TOWN_NIGHT, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> DUNGEON_FLOOR_1 = CMMusics.register(CMSoundEvents.DUNGEON_FLOOR_1, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> DUNGEON_FLOOR_2 = CMMusics.register(CMSoundEvents.DUNGEON_FLOOR_2, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> BOSS_1 = CMMusics.register(CMSoundEvents.BOSS_1, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> BOSS_2 = CMMusics.register(CMSoundEvents.BOSS_2, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> BOSS_3 = CMMusics.register(CMSoundEvents.BOSS_3, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> BOSS_4 = CMMusics.register(CMSoundEvents.BOSS_4, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> BOSS_5 = CMMusics.register(CMSoundEvents.BOSS_5, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> DEERCLOPS = CMMusics.register(CMSoundEvents.DEERCLOPS, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> WALL_OF_FLESH = CMMusics.register(CMSoundEvents.WALL_OF_FLESH, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> QUEEN_SLIME = CMMusics.register(CMSoundEvents.QUEEN_SLIME, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> PLANTERA = CMMusics.register(CMSoundEvents.PLANTERA, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> EMPRESS_OF_LIGHT = CMMusics.register(CMSoundEvents.EMPRESS_OF_LIGHT, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> DUKE_FISHRON = CMMusics.register(CMSoundEvents.DUKE_FISHRON, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> MOON_LORD = CMMusics.register(CMSoundEvents.MOON_LORD, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> EERIE = CMMusics.register(CMSoundEvents.EERIE, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> ECLIPSE = CMMusics.register(CMSoundEvents.ECLIPSE, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> GOBLIN_ARMY = CMMusics.register(CMSoundEvents.GOBLIN_ARMY, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> PIRATE_INVASION = CMMusics.register(CMSoundEvents.PIRATE_INVASION, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> MARTIAN_MADNESS = CMMusics.register(CMSoundEvents.MARTIAN_MADNESS, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> PUMPKIN_MOON = CMMusics.register(CMSoundEvents.PUMPKIN_MOON, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> FROST_MOON = CMMusics.register(CMSoundEvents.FROST_MOON, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> THE_TOWERS = CMMusics.register(CMSoundEvents.THE_TOWERS, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> SANDSTORM = CMMusics.register(CMSoundEvents.SANDSTORM, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OLD_ONES_ARMY = CMMusics.register(CMSoundEvents.OLD_ONES_ARMY, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> SLIME_RAIN = CMMusics.register(CMSoundEvents.SLIME_RAIN, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> WINDY_DAY = CMMusics.register(CMSoundEvents.WINDY_DAY, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> RAIN = CMMusics.register(CMSoundEvents.RAIN, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> MORNING_RAIN = CMMusics.register(CMSoundEvents.MORNING_RAIN, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> STORM = CMMusics.register(CMSoundEvents.STORM, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_RAIN = CMMusics.register(CMSoundEvents.OTHERWORLDLY_RAIN, Type.COMMON);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_OVERWORLD_DAY = CMMusics.register(CMSoundEvents.OTHERWORLDLY_OVERWORLD_DAY, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_NIGHT = CMMusics.register(CMSoundEvents.OTHERWORLDLY_NIGHT, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_UNDERGROUND = CMMusics.register(CMSoundEvents.OTHERWORLDLY_UNDERGROUND, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_DESERT = CMMusics.register(CMSoundEvents.OTHERWORLDLY_DESERT, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_OCEAN = CMMusics.register(CMSoundEvents.OTHERWORLDLY_OCEAN, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_MUSHROOMS = CMMusics.register(CMSoundEvents.OTHERWORLDLY_MUSHROOMS, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_JUNGLE = CMMusics.register(CMSoundEvents.OTHERWORLDLY_JUNGLE, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_DUNGEON = CMMusics.register(CMSoundEvents.OTHERWORLDLY_DUNGEON, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_SPACE = CMMusics.register(CMSoundEvents.OTHERWORLDLY_SPACE, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_ICE = CMMusics.register(CMSoundEvents.OTHERWORLDLY_ICE, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_UNDERWORLD = CMMusics.register(CMSoundEvents.OTHERWORLDLY_UNDERWORLD, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_SNOW = CMMusics.register(CMSoundEvents.OTHERWORLDLY_SNOW, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_CORRUPTION = CMMusics.register(CMSoundEvents.OTHERWORLDLY_CORRUPTION, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_UNDERGROUND_CORRUPTION = CMMusics.register(CMSoundEvents.OTHERWORLDLY_UNDERGROUND_CORRUPTION, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_CRIMSON = CMMusics.register(CMSoundEvents.OTHERWORLDLY_CRIMSON, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_UNDERGROUND_CRIMSON = CMMusics.register(CMSoundEvents.OTHERWORLDLY_UNDERGROUND_CRIMSON, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_HALLOW = CMMusics.register(CMSoundEvents.OTHERWORLDLY_HALLOW, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_UNDERGROUND_HALLOW = CMMusics.register(CMSoundEvents.OTHERWORLDLY_UNDERGROUND_HALLOW, Type.LOCATION);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_EERIE = CMMusics.register(CMSoundEvents.OTHERWORLDLY_EERIE, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_BOSS_1 = CMMusics.register(CMSoundEvents.OTHERWORLDLY_BOSS_1, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_BOSS_2 = CMMusics.register(CMSoundEvents.OTHERWORLDLY_BOSS_2, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_INVASION = CMMusics.register(CMSoundEvents.OTHERWORLDLY_INVASION, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_THE_TOWERS = CMMusics.register(CMSoundEvents.OTHERWORLDLY_THE_TOWERS, Type.EVENT);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_LUNAR_BOSS = CMMusics.register(CMSoundEvents.OTHERWORLDLY_LUNAR_BOSS, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_PLANTERA = CMMusics.register(CMSoundEvents.OTHERWORLDLY_PLANTERA, Type.BOSS);
    public static final DeferredHolder<CachedLocationMusic, CachedLocationMusic> OTHERWORLDLY_WALL_OF_FLESH = CMMusics.register(CMSoundEvents.OTHERWORLDLY_WALL_OF_FLESH, Type.BOSS);

    private static DeferredHolder<CachedLocationMusic, CachedLocationMusic> register(DeferredHolder<SoundEvent, SoundEvent> sound, Type type) {
        return MUSICS.register(sound.getId().getPath(), () -> new CachedLocationMusic((Holder<SoundEvent>)sound, type));
    }

    public static enum Type implements StringRepresentable
    {
        COMMON,
        LOCATION,
        BOSS,
        EVENT;

        public static final Codec<Type> CODEC;

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public static class CachedLocationMusic
    extends Music {
        public static final Codec<CachedLocationMusic> CODEC = ConfluenceMusic.CACHED_LOCATION_MUSIC.byNameCodec();
        private ResourceLocation location;
        private final Type type;

        public CachedLocationMusic(Holder<SoundEvent> event, Type type) {
            super(event, 0, 0, true);
            this.type = type;
        }

        public ResourceLocation getLocation() {
            if (this.location == null) {
                this.location = ((SoundEvent)this.getEvent().value()).getLocation();
            }
            return this.location;
        }

        public Type getType() {
            return this.type;
        }
    }
}

