/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.music.client;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.SelectMusicEvent;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.api.entity.Boss;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.client.gameevent.ClientGameEventSystem;
import org.confluence.mod.client.handler.WeatherHandler;
import org.confluence.mod.common.data.saved.SpecificMoonVariant;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.music.ConfluenceMusic;
import org.confluence.music.client.CMClientConfigs;
import org.confluence.music.client.MusicSelection;
import org.confluence.music.client.MusicSelectionLoader;
import org.confluence.music.common.CMCommonConfigs;
import org.confluence.music.common.init.CMMusics;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="confluence_music", value={Dist.CLIENT})
public final class MusicHandler {
    public static final ResourceLocation CONFLUENCE = ConfluenceMusic.asResource("confluence");
    public static final ResourceLocation OTHERWORLDLY = ConfluenceMusic.asResource("otherworldly");
    private static final RandomSource RANDOM = RandomSource.create();
    private static final Function<EntityType<?>, MusicSelection> bossMusicSelector = new Function<EntityType<?>, MusicSelection>(){
        private Map<EntityType<?>, MusicSelection> cache;

        @Override
        @Nullable
        public MusicSelection apply(EntityType<?> entityType) {
            if (this.cache == null) {
                this.cache = new IdentityHashMap();
                this.cache.put((EntityType)TEBossEntities.KING_SLIME.get(), MusicSelection.KING_SLIME);
                this.cache.put((EntityType)TEBossEntities.EYE_OF_CTHULHU.get(), MusicSelection.EYE_OF_CTHULHU);
                this.cache.put((EntityType)TEBossEntities.EATER_OF_WORLDS.get(), MusicSelection.EATER_OF_WORLDS);
                this.cache.put((EntityType)TEBossEntities.BRAIN_OF_CTHULHU.get(), MusicSelection.BRAIN_OF_CTHULHU);
                this.cache.put((EntityType)TEBossEntities.DEERCLOPS.get(), MusicSelection.DEERCLOPS);
                this.cache.put((EntityType)TEBossEntities.QUEEN_BEE.get(), MusicSelection.QUEEN_BEE);
                this.cache.put((EntityType)TEBossEntities.SKELETRON.get(), MusicSelection.SKELETRON);
                this.cache.put((EntityType)TEBossEntities.WALL_OF_FLESH.get(), MusicSelection.WALL_OF_FLESH);
                this.cache.put((EntityType)TEBossEntities.HILL_OF_FLESH.get(), MusicSelection.WALL_OF_FLESH);
                this.cache.put((EntityType)TEBossEntities.THE_TWINS.get(), MusicSelection.THE_TWINS);
                this.cache.put((EntityType)TEBossEntities.SKELETRON_PRIME.get(), MusicSelection.SKELETRON_PRIME);
                this.cache.put((EntityType)TEBossEntities.THE_DESTROYER.get(), MusicSelection.THE_DESTROYER);
                this.cache.put((EntityType)TEBossEntities.PLANTERA.get(), MusicSelection.PLANTERA);
            }
            return this.cache.get(entityType);
        }
    };
    private static final int _07$30 = LibDateUtils.getDayTime((int)7, (int)30);
    private static CMMusics.CachedLocationMusic nextSong;
    private static int nextSongDelay;
    private static Holder<Biome> lastBiome;
    static int nextBiomeCheck;
    private static float volume;
    private static boolean hasBossMusic;
    private static byte structureMusic;
    private static MusicSelection lastSelection;

    public static void handle(SelectMusicEvent event, LocalPlayer player, Minecraft minecraft) {
        if (nextBiomeCheck-- <= 0) {
            Holder biome = player.level().getBiome(player.blockPosition());
            if (biome != lastBiome) {
                lastBiome = biome;
                nextSongDelay = 0;
                nextSong = null;
                lastSelection = null;
            }
            nextBiomeCheck = CMCommonConfigs.checkInterval;
        }
        MusicHandler.selectBossMusic(player, minecraft);
        MusicHandler.selectStructureMusic();
        MusicHandler.selectBiomeMusic(player);
        SoundInstance playingMusic = event.getPlayingMusic();
        if ((playingMusic == null || nextSong != null && MusicHandler.isSameModButDifferentSong(nextSong.getLocation(), playingMusic.getLocation())) && nextSongDelay-- <= 0) {
            if (volume > 0.0f) {
                volume = Mth.clamp((float)(Math.min(volume, playingMusic == null ? 1.0f : playingMusic.getSound().getVolume().sample(player.getRandom())) - CMClientConfigs.lastSongFadeOutStep), (float)0.0f, (float)1.0f);
                float v = minecraft.options.getSoundSourceVolume(SoundSource.MUSIC) * volume;
                ChannelAccess.ChannelHandle handle = (ChannelAccess.ChannelHandle)minecraft.getSoundManager().soundEngine.instanceToChannel.get(playingMusic);
                if (handle != null) {
                    handle.execute(channel -> {
                        if (volume <= 0.0f) {
                            channel.stop();
                        } else {
                            channel.setVolume(v);
                        }
                    });
                }
            } else {
                minecraft.getMusicManager().stopPlaying();
                event.setMusic((Music)nextSong);
                nextSongDelay = CMClientConfigs.nextSongDelay;
                volume = 1.0f;
                nextSong = null;
                lastSelection = null;
            }
        } else if (volume < 1.0f) {
            volume = Mth.clamp((float)(Math.min(volume, playingMusic == null ? 1.0f : playingMusic.getSound().getVolume().sample(player.getRandom())) + CMClientConfigs.lastSongFadeOutStep), (float)0.0f, (float)1.0f);
            float v = minecraft.options.getSoundSourceVolume(SoundSource.MUSIC) * volume;
            ChannelAccess.ChannelHandle handle = (ChannelAccess.ChannelHandle)minecraft.getSoundManager().soundEngine.instanceToChannel.get(playingMusic);
            if (handle != null) {
                handle.execute(channel -> channel.setVolume(v));
            }
        }
    }

    private static boolean isSameModButDifferentSong(ResourceLocation next, ResourceLocation current) {
        return next.getNamespace().equals(current.getNamespace()) && !next.getPath().equals(current.getPath());
    }

    public static void clear() {
        nextSong = null;
        lastSelection = null;
        nextSongDelay = CMClientConfigs.nextSongDelay;
        lastBiome = null;
        nextBiomeCheck = CMCommonConfigs.checkInterval;
        volume = 1.0f;
        hasBossMusic = false;
    }

    private static void selectBossMusic(LocalPlayer player, Minecraft minecraft) {
        if (minecraft.gui.getBossOverlay().shouldPlayMusic()) {
            AABB area = new AABB(player.blockPosition()).inflate(minecraft.levelRenderer.getLastViewDistance());
            for (Entity boss : player.level().getEntities((Entity)null, area, entity -> entity instanceof Boss)) {
                nextSong = MusicHandler.randomMusic(CMClientConfigs.musicType, bossMusicSelector.apply(boss.getType()));
                if (nextSong == null) continue;
                hasBossMusic = true;
                nextSongDelay = 0;
                break;
            }
        } else if (hasBossMusic && (nextSong == null || nextSong.getType() == CMMusics.Type.BOSS)) {
            hasBossMusic = false;
            nextSong = null;
            lastSelection = null;
            nextSongDelay = 0;
        }
    }

    private static void selectStructureMusic() {
        if (nextSong == null) {
            nextSong = MusicHandler.randomMusic(CMClientConfigs.musicType, switch (structureMusic) {
                case 1 -> MusicSelection.DUNGEON_FLOOR_1;
                case 2 -> MusicSelection.DUNGEON_FLOOR_2;
                default -> null;
            });
        }
    }

    private static void selectBiomeMusic(LocalPlayer player) {
        if (nextSong != null) {
            return;
        }
        BlockPos pos = player.blockPosition();
        Level level = player.level();
        Holder biome = lastBiome == null ? level.getBiome(pos) : lastBiome;
        MusicSelection selection = null;
        ResourceKey dimension = player.level().dimension();
        if (dimension != OverworldUtils.underworld() && player.getAbilities().instabuild && player.mayFly()) {
            selection = MusicSelection.CREATIVE_MODE;
        } else if (dimension == OverworldUtils.dimension()) {
            boolean isSurface;
            int dayTime = LibDateUtils.getDayTime((Level)level);
            boolean isDay = LibDateUtils.isDay((int)dayTime);
            int y = pos.getY();
            boolean bl = isSurface = y > OverworldUtils.getSurfaceY();
            selection = y > OverworldUtils.getSpaceY() ? (isDay ? MusicSelection.SPACE_DAY : MusicSelection.SPACE_NIGHT) : (biome.is(ModBiomes.GLOWING_MUSHROOM) ? MusicSelection.MUSHROOMS : (biome.is(Tags.Biomes.IS_ICY) ? (isSurface ? MusicSelection.ICE : MusicSelection.UNDERGROUND_ICE) : (biome.is(Tags.Biomes.IS_SNOWY) ? MusicSelection.SNOW : (biome.is(ModTags.Biomes.THE_CORRUPTION) ? (isSurface ? MusicSelection.THE_CORRUPTION : MusicSelection.UNDERGROUND_CORRUPTION) : (biome.is(ModTags.Biomes.THE_CRIMSON) ? (isSurface ? MusicSelection.THE_CRIMSON : MusicSelection.UNDERGROUND_CRIMSON) : (biome.is(ModTags.Biomes.THE_HALLOW) ? (isSurface ? (isDay ? MusicSelection.THE_HALLOW_DAY : MusicSelection.THE_HALLOW_NIGHT) : MusicSelection.UNDERGROUND_HALLOW) : (biome.is(Tags.Biomes.IS_DESERT) ? (isSurface ? MusicSelection.DESERT : MusicSelection.UNDERGROUND_DESERT) : (biome.is(Tags.Biomes.IS_OCEAN) ? (isDay ? MusicSelection.OCEAN_DAY : MusicSelection.OCEAN_NIGHT) : (biome.is(Tags.Biomes.IS_JUNGLE) ? (isSurface ? (isDay ? MusicSelection.JUNGLE_DAY : MusicSelection.JUNGLE_NIGHT) : MusicSelection.UNDERGROUND_JUNGLE) : (ClientGameEventSystem.moonTexture == SpecificMoonVariant.TR_BLOOD_FULL_MOON.texture ? MusicSelection.BLOOD_MOON : (level.isThundering() ? MusicSelection.STORM : (level.isRaining() ? (LibDateUtils.isWithinDayTime((int)LibDateUtils._04$30, (int)_07$30, (int)dayTime) ? MusicSelection.MORNING_RAIN : (isDay ? MusicSelection.RAIN_DAY : MusicSelection.RAIN_NIGHT)) : (WeatherHandler.WIND_SPEED.length() > 0.447f ? MusicSelection.WINDY_DAY : (player.level().getEntities((Entity)player, new AABB(player.blockPosition()).inflate(80.0), entity -> entity instanceof Npc).size() >= 3 ? (isDay ? MusicSelection.TOWN_DAY : MusicSelection.TOWN_NIGHT) : (isSurface ? (isDay ? MusicSelection.OVERWORLD_DAY : MusicSelection.OVERWORLD_NIGHT) : MusicSelection.UNDERGROUND)))))))))))))));
        } else if (dimension == OverworldUtils.underworld()) {
            selection = MusicSelection.UNDERWORLD;
        }
        nextSong = MusicHandler.randomMusic(CMClientConfigs.musicType, selection);
    }

    @Nullable
    private static CMMusics.CachedLocationMusic randomMusic(ResourceLocation type, @Nullable MusicSelection selection) {
        if (selection == null) {
            return null;
        }
        if (selection == lastSelection) {
            return nextSong;
        }
        lastSelection = selection;
        Map<ResourceLocation, Map<MusicSelection, List<CMMusics.CachedLocationMusic>>> selections = MusicSelectionLoader.getInstance().getRegisteredMusicSelections();
        Map<MusicSelection, List<CMMusics.CachedLocationMusic>> map = selections.get(type);
        if (map == null && (CONFLUENCE.equals((Object)type) || (map = selections.get(CONFLUENCE)) == null)) {
            return null;
        }
        List<CMMusics.CachedLocationMusic> list = map.get((Object)selection);
        if (list == null && (CONFLUENCE.equals((Object)type) || (list = map.get((Object)selection)) == null)) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.getFirst();
        }
        return (CMMusics.CachedLocationMusic)((Object)Util.getRandom(list, (RandomSource)RANDOM));
    }

    @SubscribeEvent
    public static void selectMusic(SelectMusicEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            MusicHandler.clear();
        } else {
            MusicHandler.handle(event, player, minecraft);
        }
    }

    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)MusicSelectionLoader.getInstance());
    }

    public static void modConfig$Loading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && "confluence_music".equals(event.getConfig().getModId())) {
            CMClientConfigs.onLoad();
        }
    }

    public static void modConfig$Reloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && "confluence_music".equals(event.getConfig().getModId())) {
            CMClientConfigs.onLoad();
        }
    }

    public static void handleStructure(byte data) {
        if (structureMusic != data) {
            structureMusic = data;
            nextSong = null;
            lastSelection = null;
            nextSongDelay = 0;
        }
    }

    static {
        nextSongDelay = 10;
        nextBiomeCheck = 20;
        volume = 1.0f;
        hasBossMusic = false;
        structureMusic = 0;
    }
}

