/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.music;

import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.worldgen.structure.DungeonStructure;
import org.confluence.mod.mixed.IStructureStart;
import org.confluence.music.client.CMClientConfigs;
import org.confluence.music.client.MusicHandler;
import org.confluence.music.common.CMCommonConfigs;
import org.confluence.music.common.init.CMMusics;
import org.confluence.music.common.init.CMSoundEvents;
import org.confluence.music.common.network.StructureFoundPacketS2C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="confluence_music")
public class ConfluenceMusic {
    public static final String MODID = "confluence_music";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ConfluenceMusic");
    public static final ResourceKey<Registry<CMMusics.CachedLocationMusic>> CACHED_LOCATION_MUSIC_KEY = ResourceKey.createRegistryKey((ResourceLocation)ConfluenceMusic.asResource("cached_location_music"));
    public static final Registry<CMMusics.CachedLocationMusic> CACHED_LOCATION_MUSIC = new RegistryBuilder(CACHED_LOCATION_MUSIC_KEY).sync(true).create();

    public ConfluenceMusic(IEventBus eventBus, ModContainer container) {
        CMCommonConfigs.register(container);
        if (LibUtils.isPhysicalClient()) {
            CMClientConfigs.register(container);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(MusicHandler::registerClientReloadListeners);
            eventBus.addListener(MusicHandler::modConfig$Loading);
            eventBus.addListener(MusicHandler::modConfig$Reloading);
        }
        CMSoundEvents.EVENTS.register(eventBus);
        CMMusics.MUSICS.register(eventBus);
        eventBus.addListener(ConfluenceMusic::registerPayloadHandlers);
        eventBus.addListener(ConfluenceMusic::modConfig$Loading);
        eventBus.addListener(ConfluenceMusic::modConfig$Reloading);
        eventBus.addListener(ConfluenceMusic::newRegistry);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(StructureFoundPacketS2C.TYPE, StructureFoundPacketS2C.STREAM_CODEC, StructureFoundPacketS2C::handle);
    }

    private static void modConfig$Loading(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON && MODID.equals(event.getConfig().getModId())) {
            CMCommonConfigs.onLoad();
        }
    }

    private static void modConfig$Reloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON && MODID.equals(event.getConfig().getModId())) {
            CMCommonConfigs.onLoad();
        }
    }

    private static void newRegistry(NewRegistryEvent event) {
        event.register(CACHED_LOCATION_MUSIC);
    }

    @EventBusSubscriber(modid="confluence_music")
    public static final class Events {
        @SubscribeEvent
        public static void playerTick(PlayerTickEvent.Post event) {
            ServerPlayer player;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).level().getGameTime() % (long)CMCommonConfigs.checkInterval == 0L) {
                boolean notFound;
                CompoundTag data = LibUtils.getOrCreatePersistedData((Player)player);
                byte B = data.getByte("confluence_music:structure_found");
                boolean bl = notFound = !DungeonStructure.iterateDungeon((ServerLevel)player.serverLevel(), (ChunkPos)player.chunkPosition(), structureStart -> {
                    IStructureStart start = IStructureStart.of((StructureStart)structureStart);
                    BoundingBox boundingBox = start.confluence$cachedBoundingBox();
                    if (boundingBox.isInside((Vec3i)player.blockPosition())) {
                        byte b = 0;
                        if (player.getY() <= (double)(boundingBox.minY() + DungeonStructure.getUpperBoundsFloor2())) {
                            b = 2;
                        } else if (player.getY() <= (double)(boundingBox.minY() + DungeonStructure.getUpperBoundsFloor1())) {
                            b = 1;
                        }
                        if (b != B) {
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StructureFoundPacketS2C(b), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            data.putByte("confluence_music:structure_found", b);
                        }
                        return true;
                    }
                    return false;
                });
                if (notFound && B != 0) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StructureFoundPacketS2C(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    data.putByte("confluence_music:structure_found", (byte)0);
                }
            }
        }

        @SubscribeEvent
        public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            LibUtils.getOrCreatePersistedData((Player)event.getEntity()).putByte("confluence_music:structure_found", (byte)0);
        }
    }
}

